/****** Object:  View [dbo].[V_BC_LANC_ENDIVIDAMENTO_BANCARIO]    Script Date: 21/08/2014 10:31:02 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_BC_LANC_ENDIVIDAMENTO_BANCARIO]'))
DROP VIEW [dbo].[V_BC_LANC_ENDIVIDAMENTO_BANCARIO]
GO
GO    
--SELECT * FROM V_BC_LANC_ENDIVIDAMENTO_BANCARIO
CREATE VIEW [dbo].[V_BC_LANC_ENDIVIDAMENTO_BANCARIO] AS
SELECT     
	PG_FORN.CD_EMP, 
	PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON,
	PG_FORN.RZ_FORN, 
	'' AS NR_CNT,
	PG_TP_FORN.DS_TP, 
	SUM(CASE WHEN V_PG_DEB.STS_DP = 0 THEN
			(V_PG_DEB.VLR_SLD+V_PG_DEB.VLR_JUROS) - V_PG_DEB.VLR_DESC
		ELSE
			(V_PG_DEB.VLR_SLD+V_PG_DEB.VLR_JUROS)
		END) * -1 AS VLR_SLD,
	 'CONTAS A PAGAR' AS TIPO_PROCESSO
FROM         
	PG_FORN INNER JOIN V_PG_DEB ON 
	PG_FORN.CD_EMP = V_PG_DEB.CD_EMP AND 
	PG_FORN.CD_FORN = V_PG_DEB.CD_FORN 
	INNER JOIN PG_TP_FORN ON 
	PG_FORN.CD_EMP = PG_TP_FORN.CD_EMP AND 
	PG_FORN.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN
	INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
	V_PG_DEB.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
	V_PG_DEB.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL
WHERE     
	PG_FORN.AR_MERCANTIL = 1
	AND V_PG_DEB.VLR_SLD > 0		
	AND V_PG_DEB.STS_DP IN (0,2,6)
GROUP BY 
	PG_FORN.CD_EMP, 
	PG_FORN.RZ_FORN, 
	PG_TP_FORN.DS_TP,
	PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON
UNION ALL
SELECT 
CD_EMP,
CD_GRP_ECON,
DS_BC,
NR_CNT,
DS_TP,
SUM(VLR_LANC) AS VLR_LANC,
'BANCARIO' AS TIPO_PROCESSO
FROM (
SELECT     
	BC_BANCO.CD_EMP, 
	BC_CONTAS_PRC_GRP_ECON.CD_GRP_ECON,
	BC_BANCO.DS_BC, 
	BC_CONTAS.NR_CNT,
	CASE WHEN BC_CONTAS.TP_CNT = 8 THEN
		'CONTA DE GARANTIDA' 
	ELSE
		'CONTA DE EMPRSTIMO' 
	END AS DS_TP, 
	BC_LANC.VLR_LANC * -1 AS VLR_LANC,
	'BANCARIO' AS TIPO_PROCESSO
FROM         
	BC_CONTAS INNER JOIN BC_BANCO ON 
	BC_CONTAS.CD_EMP = BC_BANCO.CD_EMP AND 
	BC_CONTAS.CD_BC = BC_BANCO.CD_BC 
	INNER JOIN BC_LANC ON 
	BC_CONTAS.CD_EMP = BC_LANC.CD_EMP AND 
	BC_CONTAS.CD_CNT = BC_LANC.CD_CNT
	INNER JOIN BC_CONTAS_PRC_GRP_ECON ON
	BC_LANC.CD_EMP = BC_CONTAS_PRC_GRP_ECON.CD_EMP AND
	BC_LANC.CD_CNT = BC_CONTAS_PRC_GRP_ECON.CD_CNT
WHERE     
	BC_CONTAS.TP_CNT IN (8,9)
	AND BC_LANC.TP_LANC =1
UNION ALL
SELECT     
	BC_BANCO.CD_EMP, 
	BC_CONTAS_PRC_GRP_ECON.CD_GRP_ECON,
	BC_BANCO.DS_BC, 
	BC_CONTAS.NR_CNT,
	CASE WHEN BC_CONTAS.TP_CNT = 8 THEN
		'CONTA DE GARANTIDA' 
	ELSE
		'CONTA DE EMPRSTIMO' 
	END AS DS_TP, 
	BC_LANC.VLR_LANC,
	'BANCARIO' AS TIPO_PROCESSO
FROM         
	BC_CONTAS INNER JOIN BC_BANCO ON 
	BC_CONTAS.CD_EMP = BC_BANCO.CD_EMP AND 
	BC_CONTAS.CD_BC = BC_BANCO.CD_BC 
	INNER JOIN BC_LANC ON 
	BC_CONTAS.CD_EMP = BC_LANC.CD_EMP AND 
	BC_CONTAS.CD_CNT = BC_LANC.CD_CNT
	INNER JOIN BC_CONTAS_PRC_GRP_ECON ON
	BC_LANC.CD_EMP = BC_CONTAS_PRC_GRP_ECON.CD_EMP AND
	BC_LANC.CD_CNT = BC_CONTAS_PRC_GRP_ECON.CD_CNT
WHERE     
	BC_CONTAS.TP_CNT IN (8,9)
	AND BC_LANC.TP_LANC = 0) AS TMP
GROUP BY
CD_EMP,
DS_BC,
NR_CNT,
DS_TP,
CD_GRP_ECON


